#ifndef __CEmail__
#define __CEmail__

#include "../Basics/CString.hpp"
#include "../Collections/TCountedPointerArray.hpp"
#include "CFileInformation.hpp"

using Exponent::Collections::TCountedPointerArray;
using Exponent::Basics::CString;
using Exponent::Host::CFileInformation;

//	===========================================================================

namespace Exponent
{
	namespace Host
	{
		/**
		 * @class CEmail CEmail.hpp
		 * @brief Allows you to send an email message
		 *
		 * @date 20/09/2006
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: CEmail.hpp,v 1.4 2007/02/08 21:06:44 paul Exp $
		 */
		class CEmail
		{
		public:

//	===========================================================================

			/**
			 * @struct SEmailDescription CEmail.hpp
			 * @brief Small Struct that needs to be filled in to send an email
			 *
			 * @date 20/09/2006
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2006 Exponent.\n
			 * You may not redistribute the source files in any way (except compiled), unless expressly sanctioned by Exponent.\n
			 * All content is the Intellectual property of Exponent.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please email plugins@expdigital.co.uk
			 */
			struct SEmailDescription
			{
				CString m_recipient;										/**< The email address of the recipient, should be of the format a@b.com */
				CString m_recipientDisplayName;								/**< The name to display. Can be same as above of something like "My Companies Tech Support" */
				CString m_subject;											/**< The message subject name */
				CString m_messageBody;										/**< The text to disply in the body of te message */
				TCountedPointerArray<CFileInformation> m_attatchments;		/**< The file attatchments, may be empty */
				bool m_sendAutomatically;									/**< Should the email be sent silently and in the background with no prompt?? */
			};

			/**
			 * Send an email. This opens the default host application for email and sets up an email. It is up to the end user to decide if they want to send this
			 * @param email The email information to send
			 * @retval bool True on sucess (email window opened), false on an error
			 */
			static bool sendEmail(const SEmailDescription &email);


		};
	}
}
#endif	// End of CEmail.hpp
